/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetAllSettingsAction
extends BaseRestHandler {
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    public RestGetAllSettingsAction(Settings settings, RestController controller, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter) {
        super(settings);
        this.indexScopedSettings = indexScopedSettings;
        controller.registerHandler(RestRequest.Method.GET, "/_settings", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "get_all_settings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(Strings.EMPTY_ARRAY);
        getIndexRequest.features(GetIndexRequest.Feature.SETTINGS);
        getIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, getIndexRequest.indicesOptions()));
        getIndexRequest.local(request.paramAsBoolean("local", getIndexRequest.local()));
        getIndexRequest.humanReadable(request.paramAsBoolean("human", false));
        request.paramAsBoolean("flat_settings", false);
        final boolean defaults = request.paramAsBoolean("include_defaults", false);
        return channel -> client.admin().indices().getIndex(getIndexRequest, (ActionListener<GetIndexResponse>)new RestBuilderListener<GetIndexResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (String index : response.indices()) {
                    builder.startObject(index);
                    this.writeSettings(response.settings().get(index), builder, request, defaults);
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }

            private void writeSettings(Settings settings, XContentBuilder builder, ToXContent.Params params, boolean defaults2) throws IOException {
                builder.startObject("settings");
                settings.toXContent(builder, params);
                builder.endObject();
                if (defaults2) {
                    builder.startObject("defaults");
                    RestGetAllSettingsAction.this.settingsFilter.filter(RestGetAllSettingsAction.this.indexScopedSettings.diff(settings, RestGetAllSettingsAction.this.settings)).toXContent(builder, request);
                    builder.endObject();
                }
            }
        });
    }
}

