/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.MatchPosition;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;

public class RemoteRuleFilters {
    public static final String RULE_FILE = "remote-rule-filters.xml";
    private static final LoadingCache<Language, Map<String, List<AbstractPatternRule>>> rules = CacheBuilder.newBuilder().build(CacheLoader.from(RemoteRuleFilters::load));

    public static final List<RuleMatch> filterMatches(@NotNull Language lang, @NotNull AnalyzedSentence sentence, @NotNull List<RuleMatch> matches) throws ExecutionException, IOException {
        if (matches.isEmpty()) {
            return matches;
        }
        Set matchIds = matches.stream().map(m -> m.getRule().getId()).collect(Collectors.toSet());
        List filters = ((Map)rules.get((Object)lang)).entrySet().stream().filter(e -> matchIds.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        HashMap<MatchPosition, Set> filterRulesByPosition = new HashMap<MatchPosition, Set>();
        for (AbstractPatternRule rule : filters) {
            RuleMatch[] filterMatches;
            for (RuleMatch match2 : filterMatches = rule.match(sentence)) {
                MatchPosition pos = new MatchPosition(match2.getFromPos(), match2.getToPos());
                filterRulesByPosition.computeIfAbsent(pos, k -> new HashSet()).add(rule);
            }
        }
        List<RuleMatch> filteredMatches = matches.stream().filter(match -> {
            MatchPosition pos = new MatchPosition(match.getFromPos(), match.getToPos());
            boolean matched = filterRulesByPosition.getOrDefault(pos, Collections.emptySet()).stream().anyMatch(rule -> rule.getId().equals(match.getRule().getId()));
            if (matched) {
                System.out.println("Removing match " + match + " - matched filter");
            }
            return !matched;
        }).collect(Collectors.toList());
        return filteredMatches;
    }

    public static void main(String[] args) throws ExecutionException {
        String langCode = args.length > 0 ? args[0] : "en";
        Language lang = Languages.getLanguageForShortCode(langCode);
        ((Map)RemoteRuleFilters.rules.get((Object)lang)).forEach((id, rules) -> {
            System.out.println("=== " + id + " ===");
            rules.forEach(System.out::println);
            System.out.println();
        });
    }

    static Map<String, List<AbstractPatternRule>> load(Language lang) {
        JLanguageTool lt = new JLanguageTool(lang);
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String filename = dataBroker.getRulesDir() + "/" + RemoteRuleFilters.getFilename(lang);
        try {
            List<AbstractPatternRule> allRules = lt.loadPatternRules(filename);
            HashMap<String, List<AbstractPatternRule>> rules = new HashMap<String, List<AbstractPatternRule>>();
            for (AbstractPatternRule rule : allRules) {
                rules.computeIfAbsent(rule.getId(), k -> new ArrayList()).add(rule);
            }
            return rules;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    static String getFilename(Language lang) {
        return lang.getShortCode() + "/" + RULE_FILE;
    }
}

