/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;

public class HunspellRule
extends SpellingCheckRule {
    public static final String RULE_ID = "HUNSPELL_RULE";
    protected boolean needsInit = true;
    protected Hunspell.Dictionary hunspellDict = null;
    private static final String NON_ALPHABETIC = "[^\\p{L}]";
    protected static final String FILE_EXTENSION = ".dic";
    private static final String[] WHITESPACE_ARRAY = new String[20];
    protected Pattern nonWordPattern;
    private final UserConfig userConfig;

    public HunspellRule(ResourceBundle messages, Language language, UserConfig userConfig) {
        super(messages, language, userConfig);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.userConfig = userConfig;
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    protected boolean isQuotedCompound(AnalyzedSentence analyzedSentence, int idx, String token) {
        return false;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.needsInit) {
            this.init();
        }
        if (this.hunspellDict == null) {
            return this.toRuleMatchArray(ruleMatches);
        }
        String[] tokens = this.tokenizeText(this.getSentenceTextWithoutUrlsAndImmunizedTokens(sentence));
        int len = sentence.getTokens()[1].getStartPos();
        for (int i = 0; i < tokens.length; ++i) {
            String word = tokens[i];
            if ((this.ignoreWord(Arrays.asList(tokens), i) || this.ignoreWord(word)) && !this.isProhibited(this.removeTrailingDot(word))) {
                len += word.length() + 1;
                continue;
            }
            if (this.isMisspelled(word)) {
                RuleMatch ruleMatch = new RuleMatch(this, sentence, len, len + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                ruleMatch.setType(RuleMatch.Type.UnknownWord);
                if (this.userConfig == null || this.userConfig.getMaxSpellingSuggestions() == 0 || ruleMatches.size() <= this.userConfig.getMaxSpellingSuggestions()) {
                    List<String> suggestions = this.getSuggestions(word);
                    List<String> additionalTopSuggestions = this.getAdditionalTopSuggestions(suggestions, word);
                    if (additionalTopSuggestions.size() == 0 && word.endsWith(".")) {
                        additionalTopSuggestions = this.getAdditionalTopSuggestions(suggestions, word.substring(0, word.length() - 1)).stream().map(k -> k + ".").collect(Collectors.toList());
                    }
                    Collections.reverse(additionalTopSuggestions);
                    for (String additionalTopSuggestion : additionalTopSuggestions) {
                        if (word.equals(additionalTopSuggestion)) continue;
                        suggestions.add(0, additionalTopSuggestion);
                    }
                    List<String> additionalSuggestions = this.getAdditionalSuggestions(suggestions, word);
                    for (String additionalSuggestion : additionalSuggestions) {
                        if (word.equals(additionalSuggestion)) continue;
                        suggestions.addAll(additionalSuggestions);
                    }
                    if (!suggestions.isEmpty()) {
                        this.filterSuggestions(suggestions);
                        this.filterDupes(suggestions);
                        ruleMatch.setSuggestedReplacements(suggestions);
                    }
                } else {
                    ruleMatch.setSuggestedReplacement(this.messages.getString("too_many_errors"));
                }
                ruleMatches.add(ruleMatch);
            }
            len += word.length() + 1;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Experimental
    public boolean isMisspelled(String word) {
        try {
            if (this.needsInit) {
                this.init();
            }
            boolean isAlphabetic = true;
            if (word.length() == 1) {
                isAlphabetic = Character.isAlphabetic(word.charAt(0));
            }
            return isAlphabetic && !"--".equals(word) && this.hunspellDict.misspelled(word) && !this.ignoreWord(word) || this.isProhibited(this.removeTrailingDot(word));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void filterDupes(List<String> words) {
        HashSet<String> seen = new HashSet<String>();
        Iterator<String> iterator = words.iterator();
        while (iterator.hasNext()) {
            String word = iterator.next();
            if (seen.contains(word)) {
                iterator.remove();
            }
            seen.add(word);
        }
    }

    private String removeTrailingDot(String word) {
        if (word.endsWith(".")) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }

    public List<String> getSuggestions(String word) throws IOException {
        if (this.needsInit) {
            this.init();
        }
        return this.hunspellDict.suggest(word);
    }

    protected String[] tokenizeText(String sentence) {
        return this.nonWordPattern.split(sentence);
    }

    protected String getSentenceTextWithoutUrlsAndImmunizedTokens(AnalyzedSentence sentence) {
        StringBuilder sb = new StringBuilder();
        AnalyzedTokenReadings[] sentenceTokens = this.getSentenceWithImmunization(sentence).getTokens();
        for (int i = 1; i < sentenceTokens.length; ++i) {
            String token = sentenceTokens[i].getToken();
            if (sentenceTokens[i].isImmunized() || sentenceTokens[i].isIgnoredBySpeller() || this.isUrl(token) || this.isEMail(token) || this.isQuotedCompound(sentence, i, token)) {
                if (this.isQuotedCompound(sentence, i, token)) {
                    sb.append(" ").append(token.substring(1));
                    continue;
                }
                if (token.length() < 20) {
                    sb.append(WHITESPACE_ARRAY[token.length()]);
                    continue;
                }
                for (int j = 0; j < token.length(); ++j) {
                    sb.append(' ');
                }
                continue;
            }
            if (token.length() > 1 && token.codePointCount(0, token.length()) != token.length()) {
                int increment;
                for (int charIndex = 0; charIndex < token.length(); charIndex += increment) {
                    int unicodeCodePoint = token.codePointAt(charIndex);
                    increment = Character.charCount(unicodeCodePoint);
                    if (increment == 1) {
                        sb.append(token.charAt(charIndex));
                        continue;
                    }
                    sb.append("  ");
                }
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @Override
    protected void init() throws IOException {
        super.init();
        String langCountry = this.language.getShortCode();
        if (this.language.getCountries().length > 0) {
            langCountry = langCountry + "_" + this.language.getCountries()[0];
        }
        String shortDicPath = "/" + this.language.getShortCode() + "/hunspell/" + langCountry + FILE_EXTENSION;
        String wordChars = "";
        if (JLanguageTool.getDataBroker().resourceExists(shortDicPath)) {
            String path = this.getDictionaryPath(langCountry, shortDicPath);
            if ("".equals(path)) {
                this.hunspellDict = null;
            } else {
                this.hunspellDict = Hunspell.getInstance().getDictionary(path);
                if (!this.hunspellDict.getWordChars().isEmpty()) {
                    wordChars = "(?![" + this.hunspellDict.getWordChars().replace("-", "\\-") + "])";
                }
                this.addIgnoreWords();
            }
        }
        this.nonWordPattern = Pattern.compile(wordChars + NON_ALPHABETIC);
        this.needsInit = false;
    }

    private void addIgnoreWords() throws IOException {
        this.hunspellDict.addWord("LanguageTool");
        URL ignoreUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.getIgnoreFileName());
        List ignoreLines = Resources.readLines((URL)ignoreUrl, (Charset)Charsets.UTF_8);
        for (String ignoreLine : ignoreLines) {
            if (ignoreLine.startsWith("#")) continue;
            this.hunspellDict.addWord(ignoreLine);
        }
    }

    private String getDictionaryPath(String dicName, String originalPath) throws IOException {
        String dictionaryPath;
        URL dictURL = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(originalPath);
        if (StringUtils.equalsAny((CharSequence)dictURL.getProtocol(), (CharSequence[])new CharSequence[]{"jar", "vfs", "bundle", "bundleresource"})) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File tempDicFile = new File(tempDir, dicName + FILE_EXTENSION);
            JLanguageTool.addTemporaryFile(tempDicFile);
            try (InputStream dicStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath);){
                this.fileCopy(dicStream, tempDicFile);
            }
            File tempAffFile = new File(tempDir, dicName + ".aff");
            JLanguageTool.addTemporaryFile(tempAffFile);
            if (originalPath.endsWith(FILE_EXTENSION)) {
                originalPath = originalPath.substring(0, originalPath.length() - FILE_EXTENSION.length()) + ".aff";
            }
            try (InputStream affStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath);){
                this.fileCopy(affStream, tempAffFile);
            }
            dictionaryPath = tempDir.getAbsolutePath() + "/" + dicName;
        } else {
            int suffixLength = FILE_EXTENSION.length();
            try {
                dictionaryPath = new File(dictURL.toURI()).getAbsolutePath();
                dictionaryPath = dictionaryPath.substring(0, dictionaryPath.length() - suffixLength);
            }
            catch (URISyntaxException e) {
                return "";
            }
        }
        return dictionaryPath;
    }

    private void fileCopy(InputStream in, File targetFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
        }
    }

    static {
        for (int i = 0; i < 20; ++i) {
            HunspellRule.WHITESPACE_ARRAY[i] = StringUtils.repeat((char)' ', (int)i);
        }
    }
}

