/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class PunctuationMarkAtParagraphEnd
extends TextLevelRule {
    private static final String[] PUNCTUATION_MARKS = new String[]{".", "!", "?", ":", ",", ";"};
    private static final String[] QUOTATION_MARKS = new String[]{"\u201e", "\u00bb", "\u00ab", "\"", "\u201d", "\u2033", "\u2019", "\u201a", "\u2018", "\u203a", "\u2039", "\u2032", "'"};
    private final Language lang;

    public PunctuationMarkAtParagraphEnd(ResourceBundle messages, Language lang) {
        super(messages);
        this.lang = Objects.requireNonNull(lang);
        super.setCategory(Categories.PUNCTUATION.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
    }

    @Override
    public String getId() {
        return "PUNCTUATION_PARAGRAPH_END";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("punctuation_mark_paragraph_end_desc");
    }

    private static boolean stringEqualsAny(String token, String[] any) {
        for (String s : any) {
            if (!token.equals(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean isQuotationMark(AnalyzedTokenReadings tk) {
        return PunctuationMarkAtParagraphEnd.stringEqualsAny(tk.getToken(), QUOTATION_MARKS);
    }

    private static boolean isPunctuationMark(AnalyzedTokenReadings tk) {
        return PunctuationMarkAtParagraphEnd.stringEqualsAny(tk.getToken(), PUNCTUATION_MARKS);
    }

    private static boolean isWord(AnalyzedTokenReadings tk) {
        return Character.isLetter(tk.getToken().charAt(0));
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int lastPara = -1;
        int pos = 0;
        boolean isFirstWord = false;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedTokenReadings[] tokens;
            AnalyzedSentence sentence = sentences.get(n);
            if ((sentence.hasParagraphEndMark(this.lang) || n == sentences.size() - 1) && (tokens = sentence.getTokensWithoutWhitespace()).length > 2) {
                boolean bl = isFirstWord = PunctuationMarkAtParagraphEnd.isWord(tokens[1]) && !PunctuationMarkAtParagraphEnd.isPunctuationMark(tokens[2]) || tokens.length > 3 && PunctuationMarkAtParagraphEnd.isQuotationMark(tokens[1]) && PunctuationMarkAtParagraphEnd.isWord(tokens[2]) && !PunctuationMarkAtParagraphEnd.isPunctuationMark(tokens[3]);
                if (n - lastPara > 1 && isFirstWord) {
                    int lastNWToken = tokens.length - 1;
                    while (tokens[lastNWToken].isLinebreak()) {
                        --lastNWToken;
                    }
                    if (PunctuationMarkAtParagraphEnd.isWord(tokens[lastNWToken]) || PunctuationMarkAtParagraphEnd.isQuotationMark(tokens[lastNWToken]) && PunctuationMarkAtParagraphEnd.isWord(tokens[lastNWToken - 1])) {
                        int fromPos = pos + tokens[lastNWToken].getStartPos();
                        int toPos = pos + tokens[lastNWToken].getEndPos();
                        RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, this.messages.getString("punctuation_mark_paragraph_end_msg"));
                        ArrayList<String> replacements = new ArrayList<String>();
                        for (String PUNCTUATION_MARK : PUNCTUATION_MARKS) {
                            replacements.add(tokens[lastNWToken].getToken() + PUNCTUATION_MARK);
                        }
                        ruleMatch.setSuggestedReplacements(replacements);
                        ruleMatches.add(ruleMatch);
                    }
                }
                lastPara = n;
                isFirstWord = false;
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

