/*
	AppHack - An Application Bundle Editor and Application Theme Tool for Mac OS X

    Copyright (C) 2004-2006 	Sveinbjorn Thordarson <sveinbjornt@simnet.is>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#import <Cocoa/Cocoa.h>
#import "DocTypeList.h"
#import "DocType.h"
#import "IconFamily.h"
#import "NibList.h"

#define	kMaxIconSize	128
#define	kMinIconSize	16

// toolbar items
#define kShowNibDrawerToolbarItemIdentifier		@"com.sveinbjornt.apphack.shownibs"
#define	kExportAllIconsToolbarItemIdentifier	@"com.sveinbjornt.apphack.exportallicons"
#define	kImportIconSetToolbarItemIdentifier		@"com.sveinbjornt.apphack.importiconset"
#define kRevealApplicationToolbarItemIdentifier @"com.sveinbjornt.apphack.revealapplication"
#define kExportPlistToolbarItemIdentifier		@"com.sveinbjornt.apphack.exportplist"
#define kImportPlistToolbarItemIdentifier		@"com.sveinbjornt.apphack.importplist"
#define kShowContentsToolbarItemIdentifier		@"com.sveinbjornt.apphack.showcontents"
#define kRevertToolbarItemIdentifier			@"com.sveinbjornt.apphack.revert"
#define kSaveAppToolbarItemIdentifier			@"com.sveinbjornt.apphack.save"
#define	kGetInfoToolbarItemIdentifier			@"com.sveinbjornt.apphack.getinfo"

@interface AppHackController : NSObject
{
	IBOutlet id addFileTypeButton;
    IBOutlet id addSuffixButton;
    IBOutlet id addDocTypeButton;
    IBOutlet id appIconView;
    IBOutlet id bundleGetInfoTextField;
    IBOutlet id bundleIdentifierTextField;
    IBOutlet id bundleNameTextField;
    IBOutlet id bundlePackageTypeTextField;
    IBOutlet id bundleShortVersionTextField;
    IBOutlet id bundleSignatureTextField;
    IBOutlet id bundleVersionTextField;
    IBOutlet id documentIconView;
    IBOutlet id editAppIconButton;
    IBOutlet id exportAppIconButton;
    IBOutlet id docTypesDataBrowser;
    IBOutlet id iconNameTextField;
    IBOutlet id importAppIconButton;
    IBOutlet id removeFileTypeButton;
    IBOutlet id removeSuffixButton;
    IBOutlet id removeDocTypeButton;
    IBOutlet id suffixesDataBrowser;
    IBOutlet id typeDataBrowser;
    IBOutlet id window;
	IBOutlet id appRoleRadioButtons;
	IBOutlet id documentBox;
	IBOutlet id noDocumentBox;
	IBOutlet id increaseIconSizeButton;
	IBOutlet id decreaseIconSizeButton;
	IBOutlet id numDocTypesTextField;
	IBOutlet id loadIndicator;
	IBOutlet id documentIconNameTextField;
	IBOutlet id revealDocIconButton;
	IBOutlet id revealAppIconButton;
	IBOutlet id exportDocIconButton;
	IBOutlet id restoreDocIconButton;
	IBOutlet id docTypeContextualMenu;
	IBOutlet id nibListDataBrowser;
	IBOutlet id nibDrawer;
	IBOutlet id revealNibButton;
	IBOutlet id nibNameTextField;
	IBOutlet id nibIconView;
	IBOutlet id nibEditButton;
	IBOutlet id emptyNibSelectionBox;
	IBOutlet id iconSizePopupMenu;
	
	IBOutlet id showToolbarMenuItem;
	IBOutlet id customizeToolbarMenuItem;
	
	NSBundle			*appBundle;
	NSString			*infoPlistPath;
	NSDictionary		*infoPlist;
	
	DocTypeList			*docTypeList;
	NibList				*nibList;
	
	NSToolbar			*toolbar;
}
- (IBAction)addFileType:(id)sender;
- (IBAction)addSuffix:(id)sender;
- (IBAction)addDocType:(id)sender;
- (IBAction)exportAppIcon:(id)sender;
- (IBAction)exportDocumentIcon:(id)sender;
- (IBAction)importAppIcon:(id)sender;
- (IBAction)importDocumentIcon:(id)sender;
- (IBAction)open:(id)sender;
- (IBAction)removeFileType:(id)sender;
- (IBAction)removeSuffix:(id)sender;
- (IBAction)removeDocType:(id)sender;
- (IBAction)revert:(id)sender;
- (IBAction)save:(id)sender;
- (IBAction)saveAs:(id)sender;
- (IBAction)selectAppIcon:(id)sender;
- (IBAction)selectDocumentIcon:(id)sender;
- (NSMutableDictionary *)generatePropertyListFromSettings;
- (void)saveApp;
- (void)loadApp: (NSString *)appPath;

- (void)setIconSize: (int)size;
- (void)updateNumDocTypes;
@end
